/* Copyright 2009 Regents of the University of California
 * All rights reserved.
 */
#ifndef _H_BILINEAR_
#define _H_BILINEAR_
#include <stdio.h>

#define FALSE 0
#define TRUE 1

typedef struct {
    int     n, m, k;
    double  *functionals;
    double  *observeds;
    char    *name;
    char    **functional_names;
} bilinear_problem_t;

void read_bilinear_coeffs(bilinear_problem_t *b, FILE *fp);
void read_to_observed(FILE *fp);
int read_observed_line(bilinear_problem_t *b, FILE *fp);

#endif
