/* Copyright 2009 Regents of the University of California
 * All rights reserved.
 */
#ifndef _H_SOLUTIONS_
#define _H_SOLUTIONS_

#include "bilinear.h"

void forward(bilinear_problem_t b, double *xs, double *ys, double *sim_data);
void print_soln(bilinear_problem_t b, double *xs, double *ys, double err);
double compute_err(bilinear_problem_t b, double *xs, double *ys);
int combine_repeats(bilinear_problem_t b, double *xs, double *ys, double *errs,
                    int num_starts);
void report_solns(bilinear_problem_t b, double *xs, double *ys, int num_starts,
        int print_extras);

#endif
