/* Copyright (C) 2010 Dustin Cartwight
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _H_POS_
#define _H_POS_

typedef struct {
    int     numvars;
    int     numeqns;
    int     numterms;
    int     *exps;    /* Array of size numterms * numvars */
    double  *coeffs;  /* Array of size numeqns * numterms */
    double  *rhs;   /* Array of size numeqns */

        /* grading for which all terms on the left-hand side have the same
         * (multi)degree */
    int    rank;
    int     *weights; /* Array of size rank * numvars */
    int     *degs;  /* Array of size rank */

        /* variable names */
    char    **varnames;

        /* For each term, this is the sum of all coefficents of that term */
    double  *coeff_totals; /* Array of size numterms */
} problem_t;

#define FALSE 0
#define TRUE 1

#endif
