/* Copyright (C) 2010 Dustin Cartwight
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _H_SOLVE_
#define _H_SOLVE_

#include "pos.h"

typedef struct {
    int     num_threads; /* number of threads to use */
    int     iters_per_soln;
    int     max_num_solns; /* number of solutions to allocate memory for */
    double  granularity;
    double  thresh;
    int     progress; /* show indication of progress */
    int     boost;
    int     newton; /* Use Newton's method instead of EM */
} solve_params_t;

typedef struct {
    double  diverg; /* K-L divergence */
    int     count; /* number of times solution was found */
    int     type; /* type of solution */
} sol_descr_t;

/* possible values for type entry of sol_descr_t */
#define TYPE_INEXACT 0
#define TYPE_NEAR_EXACT 1
#define TYPE_EXACT 2
#define TYPE_NEGATIVE 3

typedef struct {
    int         num_solns;
    double      *x; /* array of size num_solns * problem->numvars */
    sol_descr_t *descr; /* size num_solns */
} sol_set_t;

void init_solve_params(solve_params_t *params);
sol_set_t *solve(problem_t *problem, solve_params_t *params);

double *compute_monoms(problem_t *problem, double *x);

#endif
