/* Copyright (C) 1996-2000, 2006, 2007 Gerard Jungman, Brian Gough, Patrick
 *     Alken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

/* Derived from GNU Scientific Library, version 1.13, files as noted below */

#ifndef _H_SVD_
#define _H_SVD_

#include <unistd.h>

/* From block/gsl_block_double.h */

struct gsl_block_struct
{
  size_t size;
  double *data;
};

typedef struct gsl_block_struct gsl_block;

/* From vector/gsl_vector_double.h */

typedef struct 
{
  size_t size;
  size_t stride;
  double *data;
  gsl_block *block;
  int owner;
} 
gsl_vector;

gsl_vector *gsl_vector_alloc (const size_t n);

void gsl_vector_free (gsl_vector * v);

/* From matrix/gsl_matrix_double.h */

typedef struct 
{
  size_t size1;
  size_t size2;
  size_t tda;
  double * data;
  gsl_block * block;
  int owner;
} gsl_matrix;

gsl_matrix * 
gsl_matrix_alloc (const size_t n1, const size_t n2);

void gsl_matrix_free (gsl_matrix * m);

/* From linalg/gsl_linalg.h */

int gsl_linalg_SV_decomp_jacobi (gsl_matrix * A,
                                 gsl_matrix * Q,
                                 gsl_vector * S);

#endif
